\name{alt.make}
\alias{alt.make}

\title{
    Create a \code{alt} Object for Analysis of Accelerated Life (Failure) Test Data
}
\description{
    This function creates an initial alt object based on a list of alt.data objects, a distribution, 
	an accelerated life relationship model, and a method for distrubtion fitting
	}
\usage{alt.make(x, dist, alt.model, method.fit="mle-rba", goal=NULL,
					set_validation=NULL, view_dist_fits=TRUE)
	}

\arguments{
    \item{x}{
        A list of alt.data objects describing varied stress level life test data.
	}
	\item{dist}{
		A string argument defining the distribution to be used to fit life data. Accepted values are "lognormal" or "weibull". 
	}
	\item{alt.model}{
		A string argument defining the relationship model to be applied to the accelerated life tests. Accepted values are "arrhenius" or "power".
	}
	\item{method.fit}{
		A string argument defining the method to be used for fitting individual life test data sets. 
		Default value is "mle-rba". Other accpeted values are "lslr", "mle", and "mle-unbias".
	}
	\item{goal}{
		An optional alt.data object defining a proposed goal for the component under test.
	}
	\item{set_validation}{
		An optional list to modify defaults hard coded in alt.make. A set is deemed valid for wblr construction 
		and normal distribution fitting if it has at least these elements hard coded as (fail_points=2, num_fails=3, fail_range=.03).
	}
	\item{view_dist_fits}{
		A logical defining whether to generate a probability plot of the distribution fits on the input data objects.
	}
}

\details{
	The input data is scanned to reveal sufficient data for generation of an accelerated relationship model 
	while identifying sets with sparse failure data for future estimation as details are added during
	execution of \code{"alt.parallel"} and ultimatly \code{"alt.fit"}.
	
	A probability plot view of the data sets will be generated by default permitting a pre-view of the 
	parametric distribution fitting as specified. 
	
	The returned object can be plotted using S3 function \code{"plot.alt"} placing the failure points (taking intervals 
	as mean time points) in accordance with theas specified alt.model relationship .
}

\value{
    A named list of class \code{"alt"}. The first list
    item (\code{$data}) is a list with up to least three items:
    \describe{
        \item{\code{$stress}}{
            A dataframe containing the provided data formatted with \code{"left"}, \code{"right"}, and \code{"qty"} columns.
			This is the output of WeibullR function \code{"mleframe"}.
        }
        \item{\code{$data}}{
            A dataframe containing the provided data formatted with \code{"left"}, \code{"right"}, and \code{"qty"} columns.
			This is the output of WeibullR function \code{"mleframe"}.
        }
        \item{\code{$num_fails}}{
            The number of non-censored items in this data set.
        }
	Additional list items in the alt object generated by alt.make are:
        \item{\code{$goal}}{
			A list containing an alt.data object containing  a stress item and a single line dataframe containing the goal data formatted with \code{"left"}, \code{"right"}, and \code{"qty"} columns.	
        }	
        \item{\code{$dist}}{
			A string defining the distribution to be used to fit life data.	
        }	
		\item{\code{$method.fit}}{
			A string defining the method to be used for fitting individual life test data sets. 
		}	
    }	
}

\references{

  Wayne Nelson, (1990) "Accelerated Testing", Wiley-Interscience, New York
  
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York
  
  Pascual F., Meeker W., Escobar L. (2006) Accelerated Life Test Models and Data Analysis. In: Pham H. (eds) Springer Handbook of Engineering Statistics. Springer Handbooks. Springer, London. https://doi.org/10.1007/978-1-84628-288-1_22
}

\examples{
table4.1<-NelsonData("table4.1")
set170<-alt.data(x=table4.1$C170f, s=table4.1$C170s, stress=170)	
set190<-alt.data(x=table4.1$C190f, s=table4.1$C190s, stress=190)	
set220<-alt.data(x=table4.1$C220f, s=table4.1$C220s, stress=220)	
goal<-alt.data(x=35000, stress=130)	
	
ClassB_obj<-alt.make(list(set170, set190, set220), 	
	goal=goal,
	dist="lognormal",
	alt.model="arrhenius",
	view_dist_fits=FALSE
	)
}
