% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Transcriptomics_Stems}
\alias{Transcriptomics_Stems}
\title{Transcriptomics Stems}
\format{
A data frame with 30 rows and 22570 variables.
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Transcriptomics_Stems")
}
\description{
A dataset containing all the transcripts obtained by RNA-seq performed, according to the standard Illumina protocols,
on floral stems of five \emph{A. thaliana} genotypes at two growth temperatures.
See \link{Ecotype} and \link{Temperature} for more information.
}
\examples{
# Load the dataset
data("Transcriptomics_Stems")

# Look at data frame dimensions
dim(Transcriptomics_Stems)

# Look at the first rows and columns
head(Transcriptomics_Stems[,c(1:10)])

# Create a colors' vector
colors <- c(rep("#A6CEE3",3), rep("#1F78B4",3), rep("#B2DF8A",3), rep("#33A02C",3),
            rep("#FB9A99",3), rep("#E31A1C",3), rep("#FDBF6F",3), rep("#FF7F00",3),
            rep("#CAB2D6",3), rep("#6A3D9A",3))

# PCA on transcriptomics
res.pca <- prcomp(Transcriptomics_Stems, center = TRUE, scale. = TRUE)
plot(res.pca$x[,"PC1"], res.pca$x[,"PC2"], pch = 19, xlab = "PC1", ylab = "PC2", lwd = 5,
     main = "Individuals' plot (1 x 2) - PCA on Stems' Transcriptomics",
     col = colors)
text(res.pca$x[,"PC1"], res.pca$x[,"PC2"], labels = row.names(res.pca$x), cex = 0.8, pos = 3)

}
\keyword{datasets}
