% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.r
\name{replace.n.oldest}
\alias{replace.n.oldest}
\title{Rehabilitation strategy: replace the \code{n} oldest pipes}
\usage{
replace.n.oldest(state, n, max.costs = Inf)
}
\arguments{
\item{state}{a state list}

\item{n}{number of oldest pipes to replace}

\item{max.costs}{maximal amount of money allowed to be spent on this strategy}
}
\value{
a state list
}
\description{
Prioritize the oldest pipes for replacement. Pipes are only
replaced if the budget remains positive.
}
\examples{
## define a strategy function that can be passed to simulate_network():
mystrategy <- . \%>\% replace.n.oldest(n=10)

## or define a more complex strategy by combining multiple strategies
## into a prioritized sequence:
mystrategy <- . \%>\%
  replace.more.failures.than(failures=2) \%>\%
  replace.n.oldest(n=3) \%>\%
  replace.n.highest.risk(n=2, prob.failure=prob.failure.exp) \%>\%
  replace.older.than(age=8) \%>\%
  replace.n.random(n=4)

}
\seealso{
\code{\link{replace.n.highest.risk}},
\code{\link{replace.n.random}}, \code{\link{replace.older.than}},
\code{\link{replace.more.failures.than}}, \code{\link{do.nothing}}
}
\author{
Andreas Scheidegger
}
