% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lifespan.R
\name{Lifespan}
\alias{Lifespan}
\title{Generates Individual Lifespan(s)}
\usage{
Lifespan(data, ASDR, mort = NULL)
}
\arguments{
\item{data}{Data frame with individual data. If the object "data" includes date of 
birth (bdated; decimal date), then the date of death is computed.}

\item{ASDR}{Age-specific death rates}

\item{mort}{Presence or absence of mortality. This parameter is optional. Default is TRUE. If mortality is (should be) absent, mort=FALSE.}
}
\value{
\item{LS}{Data frame with age(s) at death and date(s) of death}
}
\description{
Uses age-specific death rates to simulate length of life. The function generates age(s) at
death and date(s) of death. The function uses the function rpexp() of the msm package and uniroot() of base R
}
\examples{

utils::data(dLH,package="VirtualPop")
utils::data(rates,package="VirtualPop")
d <- VirtualPop::Lifespan (dLH[1:5,1:5],ASDR=rates$ASDR)

}
