% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.varshrinkest.R
\name{logLik.varshrinkest}
\alias{logLik.varshrinkest}
\title{Log-likelihood method for class "varshrinkest"}
\usage{
\method{logLik}{varshrinkest}(object, ...)
}
\arguments{
\item{object}{An object of class "varshrinkest"}

\item{...}{Currently not used.}
}
\value{
log-likelihood of the fitted VAR model, with the \code{class}
attribute "logLik" and the attributes \code{df} and \code{nobs}.
}
\description{
Returns the log-likelihood of a VAR model estimated by \code{VARshrink()}.
It extends \code{vars::logLik.varest()} to incorporate
1) multivariate t-distribution for residuals,
2) scale matrix Sigma provided by shrinkage methods, and
3) effective number of parameters provided by shrinkage methods.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
logLik(estim)
}
