% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causality_sh.R
\name{causality_sh}
\alias{causality_sh}
\title{Causality Analysis}
\usage{
causality_sh(x, cause = NULL, vcov. = NULL, boot = FALSE, boot.runs = 100)
}
\arguments{
\item{x}{An object of class "varshrinkest" obtained by VARshrink().}

\item{cause, vcov., boot, boot.runs}{Other arguments for
causality analysis; see help(causality) for details.}
}
\value{
A list of class attribute "htest"
with the following elements: \code{Granger}, \code{Instant}.
}
\description{
Computes the test statistics for Granger- and Instantaneous causality for
a VAR(p).
}
\details{
This function runs \code{vars::causality()} for an object of class
"varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
causality_sh(estim, cause = "e")
}
\seealso{
\code{\link[vars]{causality}}
}
