% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageplot_2ts.R
\name{imageplot_2ts}
\alias{imageplot_2ts}
\title{Image Plot of 2ts hazard}
\usage{
imageplot_2ts(x, y, z, plot_options = list(), ...)
}
\arguments{
\item{x}{The coordinates for the x-axis. This is a vector of intervals
over the \code{u} axis (default), a matrix with the corner points of
the parallelograms over the \code{t} time scale, or a vector of intervals for
the \code{t} time scale.}

\item{y}{The coordinates for the y-axis. This is a vector of intervals
over the \code{s} time scale (default), or a matrix with the corner points of
the parallelograms over the \code{s} time scale.}

\item{z}{The values of the surface to plot, organized in a matrix with
dimensions compatible with those of \code{x} and \code{y}. The default is to plot the
hazard.}

\item{plot_options}{A list of options for the plot:
\itemize{
\item \code{loghazard} A Boolean. Default is \code{FALSE}. If \code{FALSE} the function
returns a plot of the hazard surface, if \code{TRUE} the function returns
a plot of the log-hazard surface.
\item \code{log10hazard} A Boolean. Default is \code{FALSE}. If \code{TRUE},
then a log10-hazard surface is plotted.
\item \code{original} A Boolean. Default is \code{TRUE}. Plot the (log-)hazard in the
(t,s)-plane. If \code{FALSE}, the (log-)hazard will be plotted in the (u,s)-plane.
\item \code{rectangular_grid} A Boolean. Default is \code{FALSE}. If \code{TRUE}, a
rectangular grid is used for plotting also in the (t,s)-plane as opposed
to the grid of parallelograms used as default in the (t,s)-plane.
\item \code{col_palette} A function defining the color palette. The default palette
is \code{rev(viridis::plasma())}.
\item \code{n_shades} The number of color shades to plot, default is 50.
\item \code{breaks} The vector of breaks for the color legend. If \code{n_shades} is provided,
this should be of length \code{n_shades + 1}. Otherwise, \code{n_shades} will be
recalculated accordingly.
\item \code{show_legend} A Boolean. Default is \code{TRUE}. If \code{FALSE} no legend will be
plotted, useful for multi-panel figures with common legend. Works only
for plots on rectangular grid!
\item \code{tmax} The maximum value of \code{t} that should be plotted.
\item \code{main} The title of the plot.
\item \code{xlab} The label of the first time axis (plotted on the x axis).
\item \code{ylab} The label of the second time axis (plotted on the y axis).
\item \code{xlim} A vector with two elements defining the limits of the time scale
on the x axis.
\item \code{ylim} A vector with two elements defining the limits of the time scale
on the y axis.
\item \code{cex_main} The magnification to be used for the main title, default is \code{1.2}.
\item \code{cex_lab} The magnification to be used for the axis labels, default is \code{1}.
\item \code{contour_lines} A Boolean. Default is \code{FALSE}. If \code{TRUE} white contour
lines are added to the surfaces.
\item \code{contour_col} The color for the contour lines. Default is \code{white}.
\item \code{contour_cex} The magnification to be used for the contour lines.
Default is \code{.8}.
\item \code{contour_nlev} The number of contour levels. Default is \code{10}.
}}

\item{\dots}{Further arguments to image.plot or image}
}
\value{
An image plot of an estimated surface.
}
\description{
\code{imageplot_2ts()} plots an image of the two time scales hazard (or survival or
cumulative hazard) with contour lines.
This is the default call implemented in plot.haz2ts.
}
