% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposures_events_Lexis.R
\name{exposures_events_Lexis}
\alias{exposures_events_Lexis}
\title{Bin data on the Lexis diagram}
\usage{
exposures_events_Lexis(t_in = NULL, t_out, s_in = NULL, s_out, ev, bins_list)
}
\arguments{
\item{t_in}{(optional) A vector of entry times on the time scale \code{t}.}

\item{t_out}{(optional) A vector of exit times on the time scale \code{t}.}

\item{s_in}{(optional) A vector of entry times on the time scale \code{s}.}

\item{s_out}{A vector of exit times on the time scale \code{s}.}

\item{ev}{A vector of event indicators (possible values 0/1).}

\item{bins_list}{A list with the following (necessary) elements:
\itemize{
\item \code{bins_t} a vector of extreme values for the bins over the \code{t} axis.
\item \code{nt} the number of bins over \code{t}.
\item \code{bins_s} a vector of extreme values for the bins over the \code{t} axis.
\item \code{ns} the number of bins over \code{s}.
}}
}
\value{
A list with the following elements:
\itemize{
\item \code{R} an array of exposure times of dimension \eqn{nt} by \eqn{ns}
\item \code{Y} an array of event counts of dimension \eqn{nt} by \eqn{ns}
}
}
\description{
\code{exposures_events_Lexis()} computes aggregated matrices of
exposure times and event counts over two time
scales, on the Lexis diagram.

The time scales are \code{t} and \code{s}. This function uses functions from
the package \code{popEpi} and from the package \code{Epi}, and code shared by Bendix Carstensen
on the website bendixcarstensen.com. See also \code{\link[=prepare_data]{prepare_data()}}
to conveniently prepare individual data for the analysis with one,
or two time scales.
}
\examples{
# ---- Bin colon cancer data by time since randomization and time since recurrence ----
# First create vectors of bins (using function `make_bins()`)
bins <- make_bins(t_out = reccolon2ts$timedc, s_out = reccolon2ts$timesr,
dt = 90, ds = 90)
# Now bin data (note: the t_in and s_in arguments are omitted because data are not left truncated)
bindata2d <- exposures_events_Lexis(t_out = reccolon2ts$timedc,
s_out = reccolon2ts$timesr, ev = reccolon2ts$status, bins = bins)

}
\references{
Carstensen B, Plummer M, Laara E, Hills M (2022).
Epi: A Package for Statistical Analysis in Epidemiology.
R package version 2.47.1, https://CRAN.R-project.org/package=Epi.

Miettinen J, Rantanen M, Seppa K (2023).
popEpi: Functions for Epidemiological Analysis using Population Data.
R package version 0.4.11, https://cran.r-project.org/package=popEpi.
}
\author{
Angela Carollo \email{carollo@demogr.mpg.de}
}
