% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Transitions}
\alias{Transitions}
\alias{add_transitions}
\alias{get_transitions}
\title{Identify Temporal Transitions in Longitudinal Study Data}
\usage{
add_transitions(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result",
  transition = "transition",
  cap = 0L,
  modulate = 0L
)

get_transitions(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result",
  cap = 0L,
  modulate = 0L
)
}
\arguments{
\item{object}{a \code{\link{data.frame}} (or object coercible by \code{\link{as.data.frame}()} to
a data frame) containing the data to be analysed.}

\item{subject}{\code{\link{character}}, name of the column (of type \code{\link{integer}} or
\code{\link{factor}}) identifying individual study subjects; default \code{"subject"}.}

\item{timepoint}{\code{character}, name of the column recording time points (as \code{\link{Dates}})
of testing of subjects; default \code{"timepoint"}.}

\item{result}{\code{character}, name of the column (of type \code{\link[base:factor]{ordered factor}},
or binary, see \emph{Details}) recording test results; default \code{"result"}.}

\item{transition}{\code{character}, name to be used for a new column (of type
\code{\link{integer}}) to record transitions; default \code{"transition"}.}

\item{cap}{\code{\link{integer}}, required for calculating transitions; default \code{0L}.}

\item{modulate}{\code{\link{integer}}, required for calculating transitions; default \code{0L}.}
}
\value{
\item{\code{add_transitions()}}{A \code{\link{data.frame}} based on \code{object}, with an added
   column of type \code{\link{integer}} containing the values of the test result transitions.}

\item{\code{get_transitions()}}{An \code{\link[base:vector]{integer vector}} of length
   \code{\link{nrow}(object)}, containing the values of the test result transitions ordered in the exact
   sequence of the \code{subject} and \code{timepoint} in \code{object}.}
}
\description{
\code{get_transitions()} identifies temporal transitions in test results for individual
subjects in a longitudinal study.

\code{add_transitions()} interpolates these transitions into a data frame for further analysis.
}
\details{
The data can be presented in any order e.g., ordered by \code{subject}, by \code{timepoint},
forwards or backwards in time, or entirely at random, and may have unbalanced designs with different
time points or numbers of test results per subject. However, the \emph{user} is responsible for
ensuring the data contain unique combinations of \code{subject}, \code{timepoint} and \code{result};
if not, outputs will be undefined.

Time points should be formatted as \code{\link{Dates}} and included in data frame \code{object} in
the column named as specified by argument \code{timepoint} (see \emph{Note}).

Test results should either be semi-quantitiative, formatted as an
\code{\link[base:ordered]{ordered factor}} (see \emph{Note}), or binary data formatted as an
\code{\link{integer}} (or \code{\link{numeric}}) vector with values of either \code{1} or \code{0},
and included in \code{object} in the data frame column specified by argument \code{result}.

Temporal transitions in the test \code{results} for each \code{subject} within the \code{object}
\code{\link{data.frame}} are characterised using methods governed by options \code{cap} and
\code{modulate}. If these two parameters are both zero (their defaults), a simple arithmetic
difference between the levels of the present and previous result is calculated. Otherwise, if
the value of \code{modulate} is a positive, non-zero integer, the arithmetic difference is
subjected to integer division by that value. Finally, if \code{cap} is a positive, non-zero
integer, the (possibly modulated) absolute arithmetic difference is capped at that value.
}
\note{
Time points represented by \code{\link{integer}} or \code{\link{numeric}} values can be converted
  to R \code{Dates} conveniently using \code{\link{as.Date}()}. If only \emph{year} information is
  available, arbitrary values could be used consistently for month and day e.g., 1st of January of
  each year; likewise, the first day of each month could be used arbitrary, if only the
  \emph{year} and \emph{month} were known. See vignette 
  \href{../doc/convertDate.pdf}{Converting numeric values to class \code{"Date"}} for examples.

Quantitive results available as \code{\link{numeric}} data can be converted to a semi-quantitative
  \code{\link[base:factor]{ordered factor}} conveniently using \code{\link{cut}()} (see \emph{examples}).
}
\examples{

  # Inspect Blackmore data frame using {base} str()
Blackmore |> str()

  # {base} hist() gives insights into the "exercise" column,
  #   useful for choosing `breaks` and `labels` in cut() below
hist(Blackmore$exercise, include.lowest = TRUE, plot = FALSE)[1:2]

  # Tweak Blackmore data frame by converting "age" to dates for the argument
  #   timepoint (using an arbitrary "origin" of 1-Jan-2000), and converting
  #   "exercise" to an ordered factor "result" with {base} cut()
Blackmore <- transform(Blackmore,
    timepoint = as.Date("2000-01-01") + round(age * 365.25),
    result = cut(
        exercise,
        breaks = seq(0, 30, 2),
        labels = paste0("<=", seq(0, 30, 2)[-1]),
        include.lowest = TRUE,
        ordered_result = TRUE
    )
)

  # subject, timepoint and result arguments now defaults and required types
Blackmore |> str()

  # Integer vector of test result transitions (defaults: cap = modulate = 0)
get_transitions(Blackmore)

  # Tabulate values of transitions
get_transitions(Blackmore) |> table()

  # Effect of cap argument
get_transitions(Blackmore, cap = 6) |> table()

  # Effect of modulate argument
get_transitions(Blackmore, modulate = 2) |> table()

  # Add column of test result transitions to data frame
add_transitions(Blackmore) |> head(22)

  # Showing transitions as either positive (1) or negative (-1)
  #   (defaults to modulate = 0)
add_transitions(Blackmore, cap = 1) |> head(14)

rm(Blackmore)

}
\seealso{
\code{\link{data.frame}}, \code{\link{Dates}}, and \code{\link[base:factor]{ordered factor}}.

Other transitions: 
\code{\link{PreviousDate}},
\code{\link{PreviousResult}},
\code{\link{uniques}()}
}
\concept{transitions}
