% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_subclasses.r
\name{ARIMA}
\alias{ARIMA}
\alias{ETS}
\alias{HW}
\alias{TF}
\alias{NNET}
\alias{RFrst}
\alias{RBF}
\alias{SVM}
\alias{MLP}
\alias{ELM}
\alias{Tensor_CNN}
\alias{Tensor_LSTM}
\title{Time series prediction models}
\usage{
ARIMA(train_par = list(), pred_par = list(level = c(80, 95)))

ETS(train_par = list(), pred_par = list(level = c(80, 95)))

HW(train_par = list(), pred_par = list(level = c(80, 95)))

TF(train_par = list(), pred_par = list(level = c(80, 95)))

NNET(
  size = 5,
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = size + 1),
  proc = list(MM = MinMax())
)

RFrst(
  ntree = 500,
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = 6),
  proc = list(MM = MinMax())
)

RBF(
  size = 5,
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = size + 1),
  proc = list(MM = MinMax())
)

SVM(
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = 6),
  proc = list(MM = MinMax())
)

MLP(
  size = 5,
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = size + 1),
  proc = list(MM = MinMax())
)

ELM(
  train_par = list(),
  pred_par = list(),
  sw = SW(window_len = 6),
  proc = list(MM = MinMax())
)

Tensor_CNN(
  train_par = NULL,
  pred_par = list(level = c(80, 95)),
  sw = SW(window_len = 6),
  proc = list(MM = MinMax())
)

Tensor_LSTM(
  train_par = NULL,
  pred_par = list(batch_size = 1, level = c(80, 95)),
  sw = SW(window_len = 6),
  proc = list(MM = MinMax())
)
}
\arguments{
\item{train_par}{List of named parameters required by \code{train_func}.}

\item{pred_par}{List of named parameters required by \code{pred_func}.}

\item{size}{See \code{\link[RSNNS]{mlp}}}

\item{sw}{A \code{\link{SW}} object regarding sliding windows processing.}

\item{proc}{A list of \code{\link{processing}} objects regarding any pre(post)processing
needed during training or prediction.}

\item{ntree}{See \code{\link[randomForest]{randomForest}}}
}
\value{
An object of class \code{modeling}.
}
\description{
Constructors for the \code{modeling} class representing a time series modeling
and prediction method based on a particular model.
}
\section{Linear models}{

	ARIMA: ARIMA model. \code{train_func} set as \code{\link[forecast]{auto.arima}}
 and \code{pred_func} set as \code{\link[forecast]{forecast}}.


	ETS: Exponential Smoothing State Space model. \code{train_func} set as \code{\link[forecast]{ets}}
 and \code{pred_func} set as \code{\link[forecast]{forecast}}.


	HW: Holt-Winter's Exponential Smoothing model. \code{train_func} set as \code{\link[forecast]{hw}}
 and \code{pred_func} set as \code{\link[forecast]{forecast}}.


	TF: Theta Forecasting model. \code{train_func} set as \code{\link[forecast]{thetaf}}
 and \code{pred_func} set as \code{\link[forecast]{forecast}}.
}

\section{Machine learning models}{

	NNET: Artificial Neural Network model. \code{train_func} set as \code{\link[nnet]{nnet}}
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	RFrst: Random Forest model. \code{train_func} set as \code{\link[randomForest]{randomForest}}
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	RBF: Radial Basis Function (RBF) Network model. \code{train_func} set as \code{\link[RSNNS]{rbf}}
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	SVM: Support Vector Machine model. \code{train_func} set as \code{\link[e1071]{tune.svm}}
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	MLP: Multi-Layer Perceptron (MLP) Network model. \code{train_func} set as \code{\link[RSNNS]{mlp}}
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	ELM: Extreme Learning Machine (ELM) model. \code{train_func} set as \code{\link[elmNNRcpp]{elm_train}}
 and \code{pred_func} set as \code{\link[elmNNRcpp]{elm_predict}}.


	Tensor_CNN: Convolutional Neural Network - TensorFlow.
 \code{train_func} based on functions from \code{tensorflow} and \code{keras},
 and \code{pred_func} set as \code{\link[stats]{predict}}.


	Tensor_LSTM: Long Short Term Memory Neural Networks - TensorFlow.
 \code{train_func} based on functions from \code{tensorflow} and \code{keras},
 and \code{pred_func} set as \code{\link[stats]{predict}}.
}

\seealso{
Other constructors: 
\code{\link{LT}()},
\code{\link{MSE_eval}()},
\code{\link{evaluating}()},
\code{\link{modeling}()},
\code{\link{processing}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{method}
\keyword{model}
\keyword{modeling}
\keyword{prediction}
