% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R, R/plot.pcasyncsa.R
\encoding{UTF-8}
\name{pca}
\alias{pca}
\alias{print.pcasyncsa}
\alias{plot.pcasyncsa}
\title{Principal Components Analysis (PCA) with NA (missing data)}
\usage{
pca(data)

\method{plot}{pcasyncsa}(
  x,
  show = c("variables", "individuals"),
  axis = c(1, 2),
  xlab = axis[1],
  ylab = axis[2],
  arrows = TRUE,
  text = TRUE,
  points = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame  or matrix with individuals in rows and variables in columns.}

\item{x}{A object of class pcasyncsa.}

\item{show}{Draw "variables" or "individuals".}

\item{axis}{Axis for draw, must have length equal to two (Default axis = c(1, 2)).}

\item{xlab}{Text for x label (Default xlab = axis[1]).}

\item{ylab}{Text for y label (Default ylab = axis[2]).}

\item{arrows}{Logical argument (TRUE or FALSE) to specify if arrows are showed for variables (Default arrows = TRUE).}

\item{text}{Logical argument (TRUE or FALSE) to specify if text are showed for individuals (Default text = TRUE).}

\item{points}{Logical argument (TRUE or FALSE) to specify if points are showed for individuals (Default points = FALSE).}

\item{...}{Parameters for \code{\link{plot}} function.}
}
\value{
\item{decomposition}{list with the results of decomposition of correlation matrix.}
\item{eigenvalues}{Data frame containing all the eigenvalues, the
percentage of inertia and the cumulative percentage of inertia.}
\item{individuals}{Coordinates for the individuals.}
\item{variables}{Correlation between original variables and axes.}
}
\description{
The function use the option "pairwise.complete.obs" (in function \code{\link{cor}}) for
calculate the correlation. The correlation between each pair of variables is computed
using all complete pairs of observations on those variables.
}
\examples{
data(ADRS)
traits<-ADRS$traits
# Some NA
traits[c(1,5),1]<-NA
traits[3,2]<-NA
traits
res<-pca(traits)
res
plot(res, show = "variables", arrows = TRUE)
plot(res, show = "individuals", axis = c(1, 2), text = TRUE)
plot(res, show = "individuals", text = FALSE, points = TRUE)
}
\seealso{
\code{\link{syncsa}}
\code{\link{syncsa}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
