% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R, R/table_saved.R
\name{sc_table}
\alias{sc_table}
\alias{sc_examples_list}
\alias{sc_example}
\alias{sc_table_saved_list}
\alias{sc_table_saved}
\title{Create a request against the /table endpoint}
\usage{
sc_table(json, language = NULL, add_totals = TRUE, key = NULL, json_file = NA)

sc_examples_list()

sc_example(filename)

sc_table_saved_list(key = NULL, server = "ext")

sc_table_saved(table_uri, language = NULL, key = NULL, server = "ext")
}
\arguments{
\item{json}{Path to a json file, which was downloaded via the STATcube
GUI ("Open Data API Request"). Alternatively, a json string which
passes \code{\link[jsonlite:validate]{jsonlite::validate()}}.}

\item{language}{The language to be used for labeling. \code{"en"} (the default)
will use english. \code{"de"} uses German.
The third option \code{"both"} will import both languages by sending two requests
to the \verb{/table} endpoint.}

\item{add_totals}{Should totals be added for each classification field in
the json request?}

\item{key}{(\code{string}) An API key. To display your key, call
\code{\link[=sc_browse_preferences]{sc_browse_preferences()}}.}

\item{json_file}{Deprecated. Use \code{json} instead}

\item{filename}{The name of an example json file.}

\item{server}{A STATcube API server. Defaults to the external Server via
\code{"ext"}. Other options are \code{"red"} for the editing server and \code{"prod"} for
the production server. External users should always use the default option \code{"ext"}.}

\item{table_uri}{Identifier of a saved table as returned by
\code{\link[=sc_table_saved_list]{sc_table_saved_list()}}}
}
\value{
An object of class \code{sc_table} which contains the return
value of the \code{\link[httr:POST]{httr::POST()}} request in \code{obj$response}. The object also
provides member functions to parse this response object. See
\link{sc_table_class} for the class documentation.
}
\description{
Send requests against the \strong{\verb{/table}} endpoint of the STATcube REST API. The
requests can use three formats with corresponding functions
\itemize{
\item \code{\link[=sc_table]{sc_table()}} uses a json file downloaded via the STATcube GUI
\item \code{\link[=sc_table_custom]{sc_table_custom()}} uses the ids of a database, measures and fields
\item \code{\link[=sc_table_saved]{sc_table_saved()}} uses a table uri of a saved table.
}

Those three functions all return an object of class \code{"sc_table"}.
}
\examples{
\dontshow{if (sc_key_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
my_table <- sc_table(json = sc_example("population_timeseries.json"))

# print
my_table

# get matadata for the table
my_table$meta

# get a data.frame
as.data.frame(my_table)

# get metadata for field 2
my_table$field(2)


# get the ids and labels of all saved tables
(saved_tables <- sc_table_saved_list())
table_uri <- saved_tables$id[1]

# get a table based on one of these ids
my_response <- sc_table_saved(table_uri)
as.data.frame(my_response)
\dontshow{\}) # examplesIf}
}
\concept{functions for /table}
