% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_endpoints.R
\name{other_endpoints}
\alias{other_endpoints}
\alias{sc_info}
\alias{sc_rate_limit_table}
\alias{sc_rate_limit_schema}
\alias{sc_rate_limits}
\title{Other endpoints of the STATcube REST API}
\usage{
sc_info(language = c("en", "de"), key = NULL, server = "ext")

sc_rate_limit_table(language = c("en", "de"), key = NULL, server = "ext")

sc_rate_limit_schema(language = c("en", "de"), key = NULL, server = "ext")

sc_rate_limits(x)
}
\arguments{
\item{language}{The language to be used for labeling. \code{"en"} or \code{"de"}}

\item{key}{(\code{string}) An API key. To display your key, call
\code{\link[=sc_browse_preferences]{sc_browse_preferences()}}.}

\item{server}{A STATcube API server. Defaults to the external Server via
\code{"ext"}. Other options are \code{"red"} for the editing server and \code{"prod"} for
the production server. External users should always use the default option \code{"ext"}.}

\item{x}{either a response-object (package \code{httr}), an object of class
\code{sc_table} or an object of class \code{sc_schema}}
}
\value{
\itemize{
\item \code{\link[=sc_info]{sc_info()}}: a \code{data.frame} with two columns identifying possible languages
\item \code{\link[=sc_rate_limit_table]{sc_rate_limit_table()}}, \code{\link[=sc_rate_limit_schema]{sc_rate_limit_schema()}}, \code{\link[=sc_rate_limits]{sc_rate_limits()}}: a \code{list} with elements
\itemize{
\item \code{remaining}: how much requests can be sent until the rate limit is reached
\item \code{limit}: the number of requests allowed per hour
\item \code{reset}: a timestamp when the rate limit will be reset
}
\item \code{\link[=sc_rate_limits]{sc_rate_limits()}}:
}
}
\description{
Utilize the simple endpoints \verb{/info} and \verb{/table_rate_limit}. Those provide
information about available locales and the amount of requests available
for calls against the \verb{/table} endpoint.
}
\section{Functions}{
\itemize{
\item \code{sc_info()}: returns information about all available database languages

\item \code{sc_rate_limit_table()}: returns a \code{list} with information about current requests-limits with
respect to the \verb{/table} endpoint. It
also shows when the limits reset which should be less than one hour
after the current time.

\item \code{sc_rate_limit_schema()}: returns a \code{list} with information about current requests-limits with
respect to the \verb{/schema} endpoint. It
also shows when the limits reset which should be less than one hour
after the current time.

\item \code{sc_rate_limits()}: gets rate limits from response headers

}}
\examples{
\dontshow{if (sc_key_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sc_info()
sc_rate_limit_table()
sc_rate_limit_schema()
sc_rate_limits(sc_schema("str:group:deake005:X_B1"))
\dontshow{\}) # examplesIf}
}
