% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotComponentResult.R
\name{plotComponentResult}
\alias{plotComponentResult}
\title{Plot non-contiguous simplivariate components by pattern type, with optional reordering}
\usage{
plotComponentResult(
  df,
  string,
  componentPatterns,
  componentScores,
  scoreCutoff = 0,
  showAxisLabels = TRUE,
  showComponentLabels = TRUE,
  title = "Detected Components",
  rearrange = FALSE,
  grayscale = TRUE
)
}
\arguments{
\item{df}{Original data matrix}

\item{string}{Best GA string (vector of length nrow(df) + ncol(df); rows first, then cols)}

\item{componentPatterns}{Vector of component types (from fitness(..., returnPatterns = TRUE))}

\item{componentScores}{Vector of fitness scores per component}

\item{scoreCutoff}{Minimum score a component must have to be shown (default: 0 = show all)}

\item{showAxisLabels}{Logical: show axis tick labels (default: TRUE)}

\item{showComponentLabels}{Logical: show component labels inside clusters (default: TRUE)}

\item{title}{Title for the plot (default: "Detected Components")}

\item{rearrange}{Logical: reorder rows and columns to group components (default: FALSE)}

\item{grayscale}{Logical: use grayscale for heatmap background (default: TRUE)}
}
\value{
ggplot object
}
\description{
Visualizes GA-detected simplivariate components on the original matrix as outlined cells,
colored by pattern type.
}
