% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleSCFplotting.R
\name{SingleSCFplotting}
\alias{SingleSCFplotting}
\title{Plot the SCF Convergence Process for a Single Round of Optimization}
\arguments{
\item{SCFData}{The tibble generated by SingleRoundOptiSCFIntegratedMonitor() describing the SCF convergence process for single round of optimization(or other Gaussian job types).}

\item{SCFconver}{A numeric vector showing the SCF convergence requirement read from the gaussian .log file.}
}
\value{
No return value, called for side effects
}
\description{
An internal function plots the generated single-round SCF convergence tibble
}
\examples{
library(dplyr)
library(stringr)
library(ggplot2)
library(tidyr)

temp_dat <- OptiSCFMonitorAsList(SCFMonitorExample())
SingleSCFplotting(temp_dat[[1]][[5]], SCFconver = -log10(temp_dat[[2]]))

}
