% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbn_strahler.R
\name{sbn_strahler}
\alias{sbn_strahler}
\title{Get node strahler order}
\usage{
sbn_strahler(g)
}
\arguments{
\item{g}{a river network as an igraph object. Must be a downstream directed graph.}
}
\value{
a vector of stream Strahler orders.
}
\description{
Calculate the reach (node) Strahler for all nodes in a river network. The function will not work if any of the nodes in the network have more than two adjacent upstream reaches (e.g. some networks generated by the OCNet package).
}
\examples{
g <- sbn_create(10, 0.7)
sbn_strahler(g)

}
