% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbn_down_dir.R
\name{sbn_down_dir}
\alias{sbn_down_dir}
\title{Convert to a downstream directed network}
\usage{
sbn_down_dir(g, mouth)
}
\arguments{
\item{g}{a river network as an igraph object.}

\item{mouth}{river mouth vertex id.}
}
\value{
A downstream directed network.
}
\description{
Convert an upstream directed or non-directed network to a downstream directed network.
}
\examples{
g <- sbn_create(10, 0.7)

# to undirected
g <- sbn_change_dir(g, method = "undir")

# undirected to downstream directed
sbn_down_dir(g, mouth = 1)

}
