% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cultivated}
\alias{cultivated}
\title{Dictionary of terms used to flag cultivated individuals}
\format{
A named list with two elements:

\describe{
\item{\code{cultivated}}{Character vector. Terms that indicate an individual is
cultivated. Imported from \code{plantR:::cultivated}.}

\item{\code{not_cultivated}}{Character vector. Terms suggesting an individual is
\emph{not} cultivated (e.g., “not cultivated”, “not planted”, “no plantada”,
“no cultivada”), including terms from \code{plantR:::notCultivated}.}
}
}
\usage{
cultivated
}
\description{
\code{cultivated} is a list of character vectors containing keywords used to
identify whether an occurrence record refers to cultivated or
non-cultivated individuals.

This object is used internally by \code{flag_cultivated()} to scan occurrence
fields (such as notes, habitat descriptions, or remarks) and classify
records as \emph{cultivated} or \emph{not cultivated} based on textual patterns.

The list combines terms from \code{plantR} (\code{plantR:::cultivated} and
\code{plantR:::notCultivated}) with additional multilingual variants commonly
found in herbarium metadata.
}
\details{
These terms are matched case-insensitively after text cleaning (e.g.,
lowercasing and accent removal).
}
\examples{
data(cultivated)

cultivated$cultivated
cultivated$not_cultivated

}
\references{
de Lima, Renato AF, et al. plantR: An R package and workflow for
managing species records from biological collections.
\strong{Methods in Ecology and Evolution}, 14.2 (2023): 332-339.
}
\seealso{
\code{flag_cultivated}
}
\keyword{datasets}
