% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_countries.R
\name{check_countries}
\alias{check_countries}
\title{Check if the records fall in the country assigned in the metadata}
\usage{
check_countries(
  occ,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  country_column,
  distance = 5,
  try_to_fix = FALSE,
  progress_bar = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{occ}{(data.frame) a dataset with occurrence records, preferably with
country information standardized using \code{standardize_countries()}.}

\item{long}{(character) column name with longitude. Default is
'decimalLongitude'.}

\item{lat}{lat (character) column name with latitude. Default is
'decimalLatitude'.}

\item{country_column}{(character) column name containing the country
information.}

\item{distance}{(numeric) maximum distance (in kilometers) a record can fall
outside the country assigned in the \code{country_column}. Default is \code{5}.}

\item{try_to_fix}{(logical) whether to check if coordinates are inverted or
transposed (see \code{fix_countries()} for details). If \code{TRUE}, coordinates
identified as inverted or transposed will be corrected. Default is \code{FALSE}.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{verbose}{(logical) whether to print messages about function progress.
Default is \code{TRUE}.}
}
\value{
The original \code{occ} data.frame with an additional column (\code{correct_country})
indicating whether each record falls within the country specified in the
metadata (\code{TRUE}) or not (\code{FALSE}).
}
\description{
Check if the records fall in the country assigned in the metadata
}
\examples{
# Load example data
data("occurrences", package = "RuHere") #Import data example
# Standardize country names
occ_country <- standardize_countries(occ = occurrences,
                                     return_dictionary = FALSE)
# Check whether records fall within assigned countries
occ_country_checked <- check_countries(occ = occ_country,
                                       country_column = "country_suggested")
}
