\name{getresidTT}
\alias{getresidTT}
\title{Travel time residuals
}
\description{Given an earthquake location
  and a set of arrival times,
  return a vector of residuals.
}
\usage{
getresidTT(Ldat, EQ, stas, vel)
}
\arguments{
  \item{Ldat}{List of arrival times
}
  \item{EQ}{List of event location, (lat, lon, z, and time)
}
  \item{stas}{station location list
}
  \item{vel}{list, velocity structure
}
}
\details{1D travel time calculation.
}
\value{vector of residuals
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{travel.time1D
}
\examples{

#########  LF is a vector of arrival time files
#####  KAM is a set of locations


data(GH, package='RSEIS')

g1 = GH$pickfile
data(VELMOD1D, package='RSEIS')

vel= VELMOD1D
WW = RSEIS::uwpfile2ypx(GH$pickfile)

twpx  = latlonz2wpx(WW, GH$pickfile$STAS )

   
    zip = LeftjustTime(twpx)


 w1 = which(!is.na(g1$STAS$lat))
         sec = g1$STAS$sec[w1]

         N = length(sec)
         Ldat =    list(
           name = g1$STAS$name[w1],
           sec = g1$STAS$sec[w1],
           phase = g1$STAS$phase[w1],
           lat=g1$STAS$lat[w1],
           lon = g1$STAS$lon[w1],
           z = g1$STAS$z[w1],
           err= g1$STAS$err[w1],
           yr = rep(g1$LOC$yr , times=N),
           jd = rep(g1$LOC$jd, times=N),
           mo = rep(g1$LOC$mo, times=N),
           dom = rep(g1$LOC$dom, times=N),
           hr =rep( g1$LOC$hr, times=N),
           mi = rep(g1$LOC$mi, times=N) )



 resids = getresidTT(Ldat, g1$LOC, g1$STAS , vel)




}
\keyword{misc}
