\name{PFoutput}
\alias{PFoutput}
\title{Write a pickfile to disk
}
\description{
Write a pickfile to disk, after updating the earthquake location,
in a variety of formats. 
}
\usage{
PFoutput(PF, stas = NULL, sol = NULL, format = 0, destdir=NULL)
}
\arguments{
  \item{PF}{Pickfile list from RSEIS
}
  \item{stas}{station list
}
  \item{sol}{solution vector, (lat, lon, z, t0)
}
  \item{format}{integer, 0=all formats, 1=native R, 2=UW, 3=csv)
  }
    \item{destdir}{character, full path to destination directory,
      default=NULL )
  }
  
}
\details{
Writes files to disk in local directory.
}
\value{Side effects: writes files to user's disk
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  The destdir (destination directory) must be provided
  for the file to be save properly.
  
  Creates a file name and writes to disk in a variety of formats.

  A destdir that is NULL will result in writing to a temporary file.

}


\seealso{SavePF, RSEIS
}
\examples{

data(GH, package='RSEIS')
g1 = GH$pickfile

####  saves pick files to disk 
PFoutput(g1, stas = NULL, sol = NULL, format = 1, destdir=tempdir() )

PFoutput(g1, stas = NULL, sol = NULL, format = 2, destdir=tempdir() )

PFoutput(g1, stas = NULL, sol = NULL, format = 3, destdir=tempdir() )

PFoutput(g1, stas = NULL, sol = NULL, format = 0, destdir=tempdir() )




}
\keyword{misc}
