PCsaveWPX<-function(twpx, destdir=NULL )
  {
##########  given a pick data frame, save
##########   to disk, based on minimum time
######  write the file in the destdir directory (folder)
    if(is.null(destdir)) {
          destdir=tempdir()
          message(paste('Writing output to ', destdir) )
      }

      
    if( identical(legitWPX(twpx),0)  )
      {

          warning("No legitimate picks", sep="\n")
          return(NULL)
      }
    else
      {

        RDATES = Qrangedatetime(twpx)

########### check  if the twpx dataframe is empty:
        if(RDATES$max$yr == 0 & RDATES$min$yr == 0)
        {
            warning('PCsaveWPX: No Min Max years')
            return()
          }
          
        fout1 = PCfiledatetime(RDATES$min, 0)

          fout2 = paste(fout1,"RDS", sep="." )

          fout3 = paste(destdir, fout2, sep="/")
        
          saveRDS(file=fout3, twpx)

          invisible(fout3)

          return(fout3)
          }

      warning("PCsaveWPX:  File not saved")
    invisible(NULL)
  }
