% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.RprobitB_fit.R
\name{update.RprobitB_fit}
\alias{update.RprobitB_fit}
\title{Update and re-fit probit model}
\usage{
\method{update}{RprobitB_fit}(
  object,
  form,
  re,
  alternatives,
  id,
  idc,
  standardize,
  impute,
  scale,
  R,
  B,
  Q,
  print_progress,
  prior,
  latent_classes,
  ...
)
}
\arguments{
\item{object}{An object of class \code{RprobitB_fit}.}

\item{form}{[\code{formula}]\cr
A model description with the structure \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{[\code{character()} | \code{NULL}]\cr
Names of covariates with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{alternatives}{[\code{character()}]\cr
The names of the choice alternatives. If not specified, the choice set is
defined by the observed choices.

If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{id}{[\code{character(1)}]\cr
The name of the column in \code{choice_data} that contains unique identifier
for each decision maker.}

\item{idc}{[\code{character(1)}]\cr
The name of the column in \code{choice_data} that contains
unique identifier for each choice situation of each decision maker.
By default, these identifier are generated by the order of appearance.}

\item{standardize}{[\code{character()} | \code{"all"}]\cr
Names of covariates that get standardized.

Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.

If \code{standardize = "all"}, all covariates get standardized.}

\item{impute}{A character that specifies how to handle missing covariate entries in
\code{choice_data}, one of:
\itemize{
\item \code{"complete_cases"}, removes all rows containing missing
covariate entries (the default),
\item \code{"zero"}, replaces missing covariate entries by zero
(only for numeric columns),
\item \code{"mean"}, imputes missing covariate entries by the mean
(only for numeric columns).
}}

\item{scale}{[\code{character(1)}]\cr
A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{R}{[\code{integer(1)}]\cr
The number of iterations of the Gibbs sampler.}

\item{B}{[\code{integer(1)}]\cr
The length of the burn-in period.}

\item{Q}{[\code{integer(1)}]\cr
The thinning factor for the Gibbs samples.}

\item{print_progress}{[\code{logical(1)}]\cr
Print the Gibbs sampler progress?}

\item{prior}{[\code{list}]\cr
A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{[\code{list()} | \code{NULL}]\cr
Optionally parameters specifying the number of latent classes and their
updating scheme. The values in brackets are the default.
\itemize{
\item \code{C} (\code{1}): The fixed number (greater or equal 1) of (initial) classes.
\item \code{wb_update} (\code{FALSE}): Set to \code{TRUE} for weight-based class updates.
\item \code{dp_update} (\code{FALSE}): Set to \code{TRUE} for Dirichlet process class updates.
\item \code{Cmax} (\code{10}): The maximum number of latent classes.
}

The following specifications are used for the weight-based updating scheme:
\itemize{
\item \code{buffer} (\code{50}): The number of iterations to wait before the next update.
\item \code{epsmin} (\code{0.01}): The threshold weight for removing a latent class.
\item \code{epsmax} (\code{0.7}): The threshold weight for splitting a latent class.
\item \code{deltamin} (\code{0.1}): The minimum mean distance before merging two classes.
\item \code{deltashift} (\code{0.5}): The scale for shifting the class means after a split.
}}

\item{...}{Currently not used.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function estimates a nested probit model based on a given
\code{RprobitB_fit} object.
}
\details{
All parameters (except for \code{object}) are optional and if not specified
retrieved from the specification for \code{object}.
}
