% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification}
\alias{classification}
\title{Preference-based classification of deciders}
\usage{
classification(x, add_true = FALSE)
}
\arguments{
\item{x}{An object of class \code{RprobitB_fit}.}

\item{add_true}{Set to \code{TRUE} to add true class memberships to output (if available).}
}
\value{
A \code{data.frame}.

The row names are the decider identifiers.

The first \code{C} columns contain the relative frequencies with which the \verb{deciders are allocated to classes. Next, the column}est` contains the
estimated class of the decider based on the highest allocation frequency.

If \code{add_true = TRUE}, the next column \code{true} contains the true class
memberships.
}
\description{
This function classifies the deciders based on their allocation to the
components of the mixing distribution.
}
\details{
The relative frequencies of which each decider was allocated to the classes
during the Gibbs sampling are displayed. Only the thinned samples after the
burn-in period are considered.
}
\seealso{
\code{\link[=update_z]{update_z()}} for the updating function of the class allocation vector.
}
