% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.RoBMA}
\alias{residuals.RoBMA}
\title{Extract method for Robust Bayesian Meta-Analysis Fits}
\usage{
\method{residuals}{RoBMA}(
  object,
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  as_samples = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted RoBMA object}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "ensemble"}.}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{as_samples}{whether posterior samples instead of a summary table should
be returned. Defaults to \code{FALSE}.}

\item{...}{additional arguments}
}
\value{
\code{pooled_effect} returns a list of tables of class 'BayesTools_table'.
}
\description{
\code{residuals.RoBMA} extract residuals based on the RoBMA model.
Only available for normal-normal models estimated using the spike-and-slab
algorithm (i.e., \code{algorithm = "ss"}).
}
\examples{
\dontrun{
require(metafor)
dat <- escalc(measure = "OR", ai = tpos, bi = tneg, ci = cpos, di = cneg,
              data = dat.bcg)

# fit meta-regression
robma_dat <- data.frame(
  logOR  = dat$yi,
  se     = sqrt(dat$vi),
  ablat  = dat$ablat,
  alloc  = dat$alloc
)

fit <- NoBMA.reg(~ ablat + alloc, data = robma_dat,
                 seed = 1, algorithm = "ss", parallel = TRUE)

residuals(fit)

}

}
\seealso{
\code{\link[=predict.RoBMA]{predict.RoBMA()}}
}
