% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{summary.RiskMap.spatial.cv}
\alias{summary.RiskMap.spatial.cv}
\title{Summarize Cross-Validation Scores for Spatial RiskMap Models}
\usage{
\method{summary}{RiskMap.spatial.cv}(object, view_all = TRUE, ...)
}
\arguments{
\item{object}{A `RiskMap.spatial.cv` object containing cross-validation scores for each
model, as obtained from \code{\link{assess_pp}}.}

\item{view_all}{Logical. If `TRUE`, stores the average scores across test sets for each
model alongside the overall average across all models. Defaults to `TRUE`.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
A matrix of summary scores with models as rows and metrics as columns, with class
`"summary.RiskMap.spatial.cv"`.
}
\description{
This function summarizes cross-validation scores for different spatial models obtained
from \code{\link{assess_pp}}.
}
\details{
The function computes and returns a matrix where rows correspond to models and columns
correspond to performance metrics (e.g., CRPS, SCRPS). Scores are weighted by subset sizes
to compute averages. Attributes of the returned object include:
\itemize{
  \item `test_set_means`: A list of average scores for each test set and model.
  \item `overall_averages`: Overall averages for each metric across all models.
  \item `view_all`: Indicates whether averages across test sets are available for visualization.
}
}
\seealso{
\code{\link{assess_pp}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}
}
