% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemmatizer.R
\name{lemmatize_tbl}
\alias{lemmatize_tbl}
\title{An R wrapper for Jagger's lemmatizer (a tibble input)}
\usage{
lemmatize_tbl(tbl, column, model_path = NULL, keep = NULL)
}
\arguments{
\item{tbl}{a tibble object.}

\item{column}{a column name of the tibble to tokenize.}

\item{model_path}{a path to the model.}

\item{keep}{a vector of POS(s) to keep. Default is \code{NULL}.}
}
\value{
a tibble.
}
\description{
An R wrapper for Jagger's lemmatizer (a tibble input)
}
\examples{
 data(sentence_example)
 res_lemmatize <- lemmatize_tbl(tibble::as_tibble(sentence_example), "text")
}
