% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraHelperFunctions.R
\name{trapz}
\alias{trapz}
\title{Trapezoidal integration of mass-spec retention time / intensity values}
\usage{
trapz(rts, ints, baseline = "none")
}
\arguments{
\item{rts}{A numeric vector of retention times across an MS peak. Should be
monotonically increasing and without duplicates or will throw a warning.}

\item{ints}{A numeric vector of measured intensities across an MS peak}

\item{baseline}{A length-1 character vector of either "none" (the default),
"square", or "trapezoid".}
}
\value{
A length-1 numeric value representing the area under the curve
}
\description{
Performs a trapezoidal Riemann sum to calculate the area under the curve
for mass-spectrometry data. Accepts a vector of retention times and the
associated intensities and returns the area.
}
\examples{
trapz(1:10, 1:10)
trapz(1:10, 10:1)

trapz(1:10, 11:20)
trapz(1:10, 11:20, baseline="square")
trapz(1:10, 11:20, baseline="trapezoid")

x_vals <- seq(-2, 2, length.out=100)
trapz(x_vals, dnorm(x_vals))

x_vals <- seq(0, pi/2, length.out=100)
trapz(x_vals, cos(x_vals))
}
