% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_find}
\alias{rx_find}
\title{Match an expression.}
\usage{
rx_find(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Exact expression to match}
}
\description{
Identify a specific pattern exactly.
}
\examples{
rx_find(value = "apple")

# create expression
x <- rx_find(value = "apples")

grepl(x, "apple")  # should be false
grepl(x, "apples") # should be true

}
\references{
Capturing group: \url{https://www.regular-expressions.info/brackets.html}

Stack Overflow: \url{https://stackoverflow.com/questions/3512471}
}
