% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pexeest.R
\name{pexeest}
\alias{pexeest}
\title{RPEXE estimate given change-points}
\usage{
pexeest(times, cens, tchange, tx)
}
\arguments{
\item{times}{All the event/censoring times used to fit the model}

\item{cens}{censoring status used to fit the model}

\item{tchange}{Change-points}

\item{tx}{Time points to estimate the survival probability}
}
\value{
quan survival probability
lamest Lambda estimates for time periods divided by the change-points
}
\description{
This function estimates the survival probability at tx when a piecewise 
exponential distribution is fitted to (times,cens) cens = 0 for censored, cens = 1 for uncensored.
the change point is tchange and lamest is the estimated parameters
}
\examples{
data(pexeest_times_censoring)
data(t100)
times = pexeest_times_censoring[,1]
cens = pexeest_times_censoring[,2]
pexeest(times, cens, 28.03014, t100)

}
