% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts_statistics.R
\name{plot_gene_detection}
\alias{plot_gene_detection}
\title{Plot number of detected genes for each sample}
\usage{
plot_gene_detection(dds, thresholds = c(3, 10, 20, 50))
}
\arguments{
\item{dds}{A DESeqDataSet}

\item{thresholds}{Vector of thresholds for which the number of genes with
counts greater or equal than the thresholds is plotted}
}
\value{
A ggplot object of the ggplot2 package that contains the gene detection plot.
}
\description{
For specified thresholds, the number of detected genes is shown for each sample.
}
\examples{
library("DESeq2")
set.seed(1)
dds <- makeExampleDESeqDataSet()
plot_gene_detection(dds)

}
