% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calpara.R
\name{calpara}
\alias{calpara}
\title{Sample size parameter calculations for detecting a specific alternative}
\usage{
calpara(data)
}
\arguments{
\item{data}{A data frame containing the relevant variables. The names for the variables should be ``Z'' for the treatment assignment, ``Y'' for the treatment outcome, ``A'' for the treatment assignment mechanism, and ``id'' for the cluster ID. The variable for the cluster ID should be a factor.}
}
\value{
A list of class \code{calpara} which contains the following item:
\item{sigmaw}{ The within-cluster variance of the potential outcomes, with the assumption that the all of the variances the same. }
\item{sigmab}{ The between-cluster variance of the potential outcomes, with the assumption that all of the variances are the same. }
\item{r}{ The intraclass correlation coefficient with respect to the potential outcomes. }
\item{sigma.tot}{ The total variance of the potential outcomes. }
\item{n.avg}{ The mean of the number of treated observations by cluster. }
}
\description{
This function calculates the parameters needed for the method to calculate sample size
references.
}
\examples{
data(jd)
data_LTFC <- data.frame(jd$assigned, jd$pct0, jd$cdd6m, jd$anonale)
colnames(data_LTFC) <- c("Z", "A", "Y", "id")
var.LTFC <- calpara(data_LTFC)

}
\references{
Zhichao Jiang, Kosuke Imai (2020).
\dQuote{Statistical Inference and Power Analysis for Direct and Spillover Effects in Two-Stage Randomized Experiments}, \emph{Technical Report}.
}
\author{
Kosuke Imai, Department of Statistics, Harvard University
\email{imai@harvard.edu}, \url{https://imai.fas.harvard.edu/};
Zhichao Jiang, School of Public Health and Health Sciences, University of Massachusetts Amherst
\email{zhichaojiang@umass.edu};
Karissa Huang, Department of Statistics, Harvard College
\email{krhuang@college.harvard.edu}
}
\keyword{experiments}
\keyword{randomized}
\keyword{two-stage}
