% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotRawMulti.R
\name{PlotRawMulti}
\alias{PlotRawMulti}
\title{Plot Multiple Samples from the Cleaned Raw Data}
\usage{
PlotRawMulti(
  raw,
  samples,
  legend_position = "topleft",
  xlim = NULL,
  ylim = NULL,
  custom_colors = NULL,
  xlab = "Time (h)",
  ylab = "Fluorescence",
  linetypes = NULL
)
}
\arguments{
\item{raw}{Cleaned raw data. Output from \code{GetCleanRaw}.}

\item{samples}{The names of the samples to plot.}

\item{legend_position}{Position of legend. Default is "topleft".
Choose from "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center".}

\item{xlim}{Numeric vector giving the x coordinate range (hours). If NULL (default), limits are computed from the data.}

\item{ylim}{Numeric vector giving the y coordinate range (relative fluorescence units). If NULL (default), limits are computed from the data.}

\item{custom_colors}{An optional vector of colors to be used for plotting.
If NULL (default), the function will use the original color scheme.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{linetypes}{Vector of line types to use for each line. Can be integer codes (1:6)
or character codes ("solid", "dashed", "dotted", "dotdash", "longdash", "twodash").
All lines will be solid by default.}
}
\value{
A plot displaying the fluorescence of the selected samples over time.
}
\description{
The function visualizes the fluorescence over time for selected samples.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)

#Clean data 
cleanraw <- CleanRaw(meta, raw, plate_time)

#Plot fluorescence curves from negative and positive controls
PlotRawMulti(cleanraw, c("Neg", "Pos"))

}
