% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BulkReadMARS.R
\name{BulkReadMARS}
\alias{BulkReadMARS}
\title{Bulk Read MARS data}
\usage{
BulkReadMARS(path, plate_subfix, raw_subfix, helper_func = NULL)
}
\arguments{
\item{path}{Character string specifying the path to the parent directory containing the data folders.}

\item{plate_subfix}{Character string used to identify plate data files.}

\item{raw_subfix}{Character string used to identify raw data files.}

\item{helper_func}{Optional function to be applied to each column of the plate data (default: NULL).}
}
\value{
A list containing data from each folder, including plate, raw, and replicate data.
}
\description{
Bulk Read MARS data
}
\details{
The example dataset, located in \verb{inst/extdata/}, consists of folders representing
individual experimental runs. This dataset is a subset of the data used in a
publication led by Dr. Stuart Lichtenberg. For detailed information about the experiments, please
contact Dr. Stuart Lichtenberg at \code{licht213@umn.edu}.

Each folder contains two Excel files:
\itemize{
\item A file with the suffix \code{plate}: Contains the plate setup and experimental information.
\item A file with the suffix \code{raw}: Contains fluorescence data exported from MARS software.
}
}
\examples{
path = system.file("extdata", package = "QuICSeedR")
data <- BulkReadMARS(path = path,
                     plate_subfix = 'plate',
                     raw_subfix = 'raw')
str(data)

}
