% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{lung_nodules_detection_dt}
\alias{lung_nodules_detection_dt}
\title{Incidental or Screen-Detected Lung Nodules}
\format{
A data table with 999 observations and 8 variables:
\describe{
  \item{sex}{Patient sex (factor with 2 levels)}
  \item{age}{Patient age in years (numeric)}
  \item{num.annotated}{Number of annotated nodules (numeric)}
  \item{location}{Nodule location (factor with 6 levels)}
  \item{spiculate}{Spiculation status (factor with 2 levels)}
  \item{smoke.status}{Smoking history (factor with 5 levels)}
  \item{diameter}{Nodule diameter in mm (numeric)}
  \item{malignant}{Malignancy status (0=benign, 1=malignant) (numeric)}
}
}
\source{
Data taken from the R4HCR package version 0.1
}
\usage{
data(lung_nodules_detection_dt)
}
\description{
This dataset, lung_nodules_detection_dt, is a data table containing clinical
and radiological characteristics of 999 pulmonary nodules (up to 15mm in size) detected
on routine chest CT scans from 3 UK academic centers.
}
\details{
The dataset name has been kept as 'lung_nodules_detection_dt' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the PulmoDataSets package. The suffix 'dt' indicates
that this is a data table object. The original content has not been modified
in any way.
}
