% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,PTModule,missing-method}
\title{Plot a PTModule object}
\usage{
\S4method{plot}{PTModule,missing}(x, y, plot.loop.positions = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the
waveforms of the \code{\link{PTSample}}s need to be plotted.}

\item{y}{\code{missing}. Argument from the generic plotting method, don't use.}

\item{plot.loop.positions}{A \code{logical} value indicating whether
loop positions need to be visualised. For looped samples, the starting
and ending positions are marked by a vertical green and red line, respectively.}

\item{...}{Arguments that are passed on to \code{\link[lattice:xyplot]{lattice::xyplot}}.}
}
\value{
Returns an object of class \code{trellis}. See documentation of
\code{\link[lattice:xyplot]{lattice::xyplot}} for more details.
}
\description{
Plots the waveforms of the (non-empty) \code{\link{PTSample}}s in a
\code{\link{PTModule}} object.
}
\details{
A plotting routine based on the \code{\link[lattice:xyplot]{lattice::xyplot}} from the
lattice-package. Plots each (non-empty) waveform in a separate panel. Use arguments
of the \code{\link[lattice:xyplot]{lattice::xyplot}} function to customise the plot.
}
\examples{
## get the example PTModule provided with the ProTrackR package
data("mod.intro")

## The most basic way to plot the module samples:
plot(mod.intro)

## By using xyplot arguments, we can make it look nicer:
plot(mod.intro, type = "l", layout = c(1,4),
     scales = list(x = list(relation = "free")))
}
\author{
Pepijn de Vries
}
