% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OperatSDI.R
\name{OperatSDI}
\alias{OperatSDI}
\title{Calculate Routine NASA-SPI and NASA-SPEI Estimates}
\usage{
OperatSDI(
  lon,
  lat,
  start.date,
  end.date,
  PEMethod = "HS",
  distr = "GEV",
  parms,
  TS = 4L
)
}
\arguments{
\item{lon}{longitude in decimal degrees.}

\item{lat}{latitude in decimal degrees.}

\item{start.date}{Date at each time when the calculation must start
(\dQuote{YYYY-MM-DD}).}

\item{end.date}{Date at each time when the calculation must end
(\dQuote{YYYY-MM-DD}).}

\item{PEMethod}{A character variable (\dQuote{HS} (Hargreaves & Samani) or
\dQuote{PM} (Penman-Monteith) defining the potential evapotranspiration
method.  Default is \dQuote{HS}.}

\item{distr}{A character variable (\dQuote{GEV} or \dQuote{GLO}) defining
which distribution is used to calculate the \acronym{SPEI}. Default is
\dQuote{GEV} (generalized extreme value) with \dQuote{GLO} (generalized
logistic distributions) as an option.}

\item{parms}{Parameters required for calculating the \acronym{SPI} and
\acronym{SPEI}.  It is provided by the \code{\link{ScientSDI}} function's
\code{DistPar}.}

\item{TS}{Time scale on the \dQuote{quart.month} basis (integer values
between 1 and 96).}
}
\value{
A data frame with six columns
\itemize{
  \item rainfall,
  \item potential evapotranspiration (PE),
  \item difference between rainfall and PE (in millimiters),
  \item the NASA-SPI,
  \item the NASA-SPEI and
  \item the SDI categories corresponding to each indices estimates.
  }
}
\description{
Calculates the \acronym{SPI} (Standardized Precipitation Index) and
  \acronym{SPEI} (Standardized Precipitation-Evapotranspiration Index) using
  \acronym{NASA} \acronym{POWER} data.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# This example is not run as it requires data to be downloaded from an API,
#  which may fail.  It also uses data included in this package, "DistPar" for
#  `parms` here

OperatSDI(
  lon = -47.3,
  lat = -22.67,
  start.date = "2023-06-01",
  end.date = "2023-06-30",
  PEMethod = "HS",
  distr = "GEV",
  parms = DistPar,
  TS = 4)
\dontshow{\}) # examplesIf}
}
