% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addemp.R
\name{addemp}
\alias{addemp}
\title{Add employers to people in employment}
\usage{
addemp(
  employers,
  empid,
  empcount,
  people,
  pplid,
  wrkhrs,
  hoursmin,
  missval = NA,
  userseed = NULL
)
}
\arguments{
\item{employers}{The data frame containing employer data.}

\item{empid}{The variable containing the unique identifier for each employer.}

\item{empcount}{The variable containing the count of employees for each employer.}

\item{people}{The data frame containing the people that require employers.}

\item{pplid}{The variable containing the unique ID for each person, in the people data frame.}

\item{wrkhrs}{The variable containing the hours worked by each person. Must be an ordered factor or numeric. If the variable is an ordered factor, the levels/values must be ascending for hours worked. This is output as an ordered factor.}

\item{hoursmin}{The wrkhrs value representing the minimum number of hours worked (numeric) or lowest factor level/number. Any wrkhrs value lower than this number/level will be treated as unemployed.}

\item{missval}{The value that will be used to replace any NA results in the output data frame. If not supplied, NA will be used for all employer-related variables for the non-working people.}

\item{userseed}{The user-defined seed for reproducibility. If left blank the normal set.seed() function will be used.}
}
\value{
A data frame of the people, with an employer ID attached to each person. Unemployed people will have an employer ID of NA, or the value specified by missval. All columns in the employers data frame, except for the employee counts, are included in the output data frame.
}
\description{
Creates a data frame of people and matching employers, if employed. Two data frames are required: one for the people and one for the employers. For people not in employment, a user-supplied missing value is used instead of the employer information.
A numeric or ordered factor for working hours is required. The minimum value for being in employment must be specified. Anyone coded under this value will be treated as unemployed. Thus, pre-cleaning the people data frame is not required.
The employer data frame can be either a summary in the form of the number of employees by employer. The other option is that each row represents a vacancy for an employee. Thus, an employer with 5 employees may be represented as either: a single row with an employee count of 5, or 5 rows with an employee count of 1 in each row.
}
\examples{

library("dplyr")

EmployedPeople <- addemp(EmployerSet, empid = "Company", empcount = "NumEmployees", Township,
                          pplid = "ID", wrkhrs = "HoursWorked", hoursmin = 2, missval = "NA",
                          userseed = 4)
}
