% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AP_pred.R
\name{pdr_predict}
\alias{pdr_predict}
\title{Predict total pool, heavy isotope pool, and atom percent}
\usage{
pdr_predict(
  time,
  m0,
  n0,
  P,
  k,
  pool = "CH4",
  frac_P = frac_P_default(pool),
  frac_k = frac_k_default(pool)
)
}
\arguments{
\item{time}{Vector of numeric time values (e.g. days); first should be zero}

\item{m0}{total pool size at time zero, as a volume}

\item{n0}{pool size of heavy isotope at time zero, as a volume}

\item{P}{production rate, unit gas/unit time}

\item{k}{first-order rate constant for consumption, 1/unit time}

\item{pool}{Name of pool; see \code{\link{pdr_fractionation}}}

\item{frac_P}{Fractionation value for production; see \code{\link{pdr_fractionation}}}

\item{frac_k}{Fractionation value for consumption; see \code{\link{pdr_fractionation}}}
}
\value{
Returns a data frame with \code{mt}, \code{nt}, and \code{AP_pred} (atom percent) for each time step
}
\description{
Predict total pool, heavy isotope pool, and atom percent
}
\note{
This is Eq. 11 from von Fischer and Hedin 2002 with a few modifications.
}
\examples{
pdr_predict(time = 0:5, m0 = 10, n0 = 1, P = 0.5, k = 0.3)
}
\author{
K.A. Morris & B. Bond-Lamberty
}
