% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Funs.R
\name{FullyParamANOVA}
\alias{FullyParamANOVA}
\title{Fully Parameterizable ANOVA test}
\usage{
FullyParamANOVA(
  InputData,
  form,
  variables_type = NULL,
  variables_relationships = c(NA),
  sig_threshold = 0.05,
  sum_of_squares = 3,
  print_ges = FALSE,
  output_table_only = FALSE
)
}
\arguments{
\item{InputData}{The name of the input dataset.}

\item{form}{To be written as \emph{Response variable ~ Explaining variable(s)}. If there are multiple \emph{Explaining variables}, they should be separated by a \emph{*}.}

\item{variables_type}{Type of variables in a vector. One argument per \emph{Explaining variable}, in the same order as in the formula: 'Fxd' for Fixed variables, or 'Rndm' for Random variables.}

\item{variables_relationships}{Relationships between variables in a vector. One argument per \emph{Explaining variable}, in the same order as in the formula:
\emph{NA} if the variable is not nested in any other variable, or the name of the variable it is nested into.}

\item{sig_threshold}{The threshold below which a p-value is considered significant. By default, it is set to the usual value of 0.05.}

\item{sum_of_squares}{Type of sum of squares used in the test: 1, 2 or 3. These numbers correspond to those in 'SAS' software. By default, the type 3 is used as it is the most often recommended one.}

\item{print_ges}{If \emph{TRUE}, prints effect sizes (ges = generalized eta squared) in the result table. See '?rstatix::anova_test()' for more details. It is \emph{FALSE} by default.}

\item{output_table_only}{If \emph{TRUE}, reports only the result table and not the text below specifying the parameters used for the test, allowing for the output table to be directly usable or stored in an object for example. It is \emph{FALSE} by default.}
}
\value{
ANOVA result table.

There is one row per effect tested and a last row for the residuals.

The first column ("Effect") specifies the effects tested.

The second column ("SS") gives the Sum of Squares associated with the effects tested.

The third column ("DF") gives the Degrees of Freedom associated with the effects tested.

The fourth column ("MSS") gives the Mean Sum of Squares (=SS/DF) associated with the effects tested.

The fifth column ("Fval") gives the F statistic value associated with the effects tested.

The sixth column ("pval") gives the p-value associated with the effects tested.

The seventh column ("Sig") shows a star if the associated p-value is below the statistical threshold of 0.05 by default or the one indicated during the call of the function for each effects tested.

The optional eighth column ("ges") gives the effect sizes (ges = generalized eta squared) associated with the effects tested.

If the argument \emph{output_table_only} is \emph{FALSE} (which is the case by default), the function also specifies below this result table which types of Sum of Squares were used,
and if there are at least two factors, it specifies which factors were fixed or random and finally the relationships between these factors.

You will find warnings below if the setup is not appropriate.
}
\description{
Function allowing the user to perform ANOVA tests (in a strict sense: one continuous and normally-distributed response variable and one or more factorial/categorical explaining variable(s)),
with the possibility to specify the type of sum of squares (1, 2 or 3), the types of variables (Fixed or Random) and their relationships (crossed or nested).
This function is built on the '?rstatix::anova_test()'.The resulting ouptuts are the same as in 'SAS' software.
}
\examples{
data("Butterfly")
# Example of ANOVA I
FullyParamANOVA(InputData=Butterfly, form=Wingspan~Site, variables_type = c('Fxd'))

# Example of ANOVA II
FullyParamANOVA(InputData=Butterfly, form=Wingspan~Patch*Site,
variables_type = c('Rndm','Fxd'), variables_relationships = c("Site",NA))

# Example of ANOVA III
FullyParamANOVA(InputData=Butterfly, form=Wingspan~Sex*Patch*Site,
variables_type = c('Fxd','Rndm','Fxd'), variables_relationships = c(NA,"Site",NA))

# Example of ANOVA III, using arguments different than those by default
# (changing the threshold below which a p-value is considered significant to 0.1,
# the types of sum of squares to 2, adding the effect sizes (ges = generalized eta squared)
# in the output table, and outputting only the table to be able to use the information within
# or store it in an object)
FullyParamANOVA(InputData=Butterfly, form=Wingspan~Sex*Patch*Site, sig_threshold=0.1,
sum_of_squares = 2, variables_type = c('Fxd','Rndm','Fxd'),
variables_relationships = c(NA,"Site",NA), print_ges = TRUE, output_table_only = TRUE)

}
