% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.PPforest.R
\name{predict.PPforest}
\alias{predict.PPforest}
\title{Predict method for PPforest objects}
\usage{
\method{predict}{PPforest}(object, newdata, rule = 1, parallel = TRUE, cores = 2, ...)
}
\arguments{
\item{object}{A fitted PPforest object}

\item{newdata}{A data frame with predictors (same structure as training data)}

\item{rule}{Split rule used in classification (integer from 1 to 8)
1: mean of two group means 
2: weighted mean of two group means - weight with group size
3: weighted mean of two group means - weight with group sd 
4: weighted mean of two group means - weight with group se 
5: mean of two group medians 
6: weighted mean of two group medians - weight with group size 
7: weighted mean of two group median - weight with group IQR 
8: weighted mean of two group median - weight with group IQR and size}

\item{parallel}{Logical, whether to use parallel processing}

\item{cores}{Number of cores to use if parallel = TRUE}

\item{...}{Additional arguments (ignored)}
}
\value{
A list with:
\describe{
  \item{predtree}{Matrix with individual tree predictions}
  \item{predforest}{Final predicted classes based on majority vote}
}
}
\description{
Predict method for PPforest objects
}
\examples{
\dontrun{
set.seed(123)
train <- sample(1:nrow(crab), nrow(crab)*.7)
crab_train <- data.frame(crab[train, ])
crab_test <- data.frame(crab[-train, ])

# if you split your data in training and test outside PPforest size.tr should be 1.
pprf.crab <- PPforest(data = crab_train, class = 'Type',
 std = 'scale', size.tr = 1, m = 200, size.p = .4, PPmethod = 'LDA', parallel = TRUE )
 
pred <- predict(pprf.crab, newdata = crab_test[,-1], parallel = TRUE) 
}
}
