% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Funnels.R
\name{assign_funnel_significance}
\alias{assign_funnel_significance}
\title{Identifies whether each value in a dataset falls outside of 95 and/or 99.8
percent control limits based on the aggregated average value across the whole
dataset as an indicator of statistically significant difference.}
\usage{
assign_funnel_significance(
  data,
  numerator,
  denominator,
  rate,
  statistic = NULL,
  rate_type = NULL,
  multiplier = NULL
)
}
\arguments{
\item{data}{a data.frame containing the data to assign significance for;
unquoted string; no default}

\item{numerator}{field name from data containing the observed numbers of
cases in the sample meeting the required condition (the numerator or
observed counts for the control limits); unquoted string; no default}

\item{denominator}{field name from data containing the population(s) in the
sample (the denominator or expected counts for the control limits);
unquoted string; no default}

\item{rate}{field name from data containing the rate data when creating
funnels for a Crude or Directly Standardised Rate; unquoted string; no
default}

\item{statistic}{type of statistic to inform funnel calculations. Acceptable
values are "proportion", "ratio" or "rate"; string; no default}

\item{rate_type}{if statistic is "rate", specify either "dsr" or "crude";
string; no default}

\item{multiplier}{the multiplier that the rate is normalised with (ie, per
100,000); only required when statistic = "rate"; numeric; no default}
}
\value{
returns the original data.frame with the significance level appended
}
\description{
This follows the funnel plot methodology published on the PHE Fingertips
Technical Guidance page:
https://fingertips.phe.org.uk/profile/guidance/supporting-information/PH-methods
}
\examples{
library(dplyr)
df <- data.frame(
  Area = c("A", "B", "C", "D"),
  numerator = c(10232, 12321, 15123, 13213),
  denominator = c(15232, 16123, 17932, 18475)
)
df \%>\%
  assign_funnel_significance(numerator, denominator,
                             statistic = "proportion", multiplier = 100)

}
\seealso{
Other PHEindicatormethods package functions: 
\code{\link{calculate_ISRate}()},
\code{\link{calculate_ISRatio}()},
\code{\link{calculate_dsr}()},
\code{\link{calculate_funnel_limits}()},
\code{\link{calculate_funnel_points}()},
\code{\link{phe_dsr}()},
\code{\link{phe_life_expectancy}()},
\code{\link{phe_mean}()},
\code{\link{phe_proportion}()},
\code{\link{phe_quantile}()},
\code{\link{phe_rate}()},
\code{\link{phe_sii}()}
}
\author{
Matthew Francis
}
\concept{PHEindicatormethods package functions}
