% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_dd}
\alias{get_dd}
\alias{get_dd_abcd}
\alias{get_dd_hbcd}
\title{Get data dictionary}
\usage{
get_dd(study, release = "latest", vars = NULL, tables = NULL)

get_dd_abcd(...)

get_dd_hbcd(...)
}
\arguments{
\item{study}{character. The study name. One of "abcd" or "hbcd".}

\item{release}{character. Release version (Default: \code{"latest"}).}

\item{vars}{character (vector). Vector with the names of variables to be
included.}

\item{tables}{character (vector). Vector with the names of tables to be
included.}

\item{...}{Additional arguments passed to the underlying
\code{\link[=get_dd]{get_dd()}} function.}
}
\value{
Data frame with the data dictionary.
}
\description{
Retrieves data dictionary for a given study and release version. Allows for
filtering by variables and tables. Wrapper around
\code{\link[=get_metadata]{get_metadata()}}.

In addition to the main \code{get_dd()} function, there are two
study-specific variations:
\itemize{
\item \code{get_dd_abcd()}: for the ABCD study.
\item \code{get_dd_hbcd()}: for the HBCD study.
}

They have the same arguments as the \code{get_dd()} function, except
that the \code{study} argument is set to the respective study by default, and
should not be set by the user.
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

get_dd("abcd")

get_dd("hbcd", release = "1.0")

get_dd("abcd", vars = c("ab_g_dyn__visit_dtt", "ab_g_dyn__visit_age"))

get_dd("abcd", tables = "ab_g_dyn")

get_dd_abcd()

get_dd_hbcd(release = "1.0")
\dontshow{\}) # examplesIf}
}
