% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calgsp1.r
\name{calgsp1}
\alias{calgsp1}
\title{Calculate group-sequential p-values for one hypothesis}
\usage{
calgsp1(
  sx = qnorm(1 - c(0.03, 0.04, 0.01)),
  scrit = qnorm(1 - c(0.01, 0.02, 0.025)),
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1
)
}
\arguments{
\item{sx}{Numeric vector of test statistics, assumed to be multivariate
normal with variance 1 and correlation matrix given by \code{smatrix}.}

\item{scrit}{Numeric vector of sequece of critical values for the test
statistics in \code{sx}. It should be computed beforehand. Must have the same
length as \code{sx}.}

\item{salpha}{Numeric vector of cumulative alpha levels for the test
statistics in \code{sx}. Must have the same length as \code{sx}.}

\item{smatrix}{Matrix with the correlation matrix of the test statistics \code{sx}.}

\item{sided}{Integer scalar indicating the side of the test:
\itemize{
\item \code{-1}: Reject if test statistic is smaller than or equal to the critical value (one-sided)
\item \code{1}: Reject if test statistic is greater or equal to the critical value (one-sided)
\item \code{0}: Reject if the absolute value of the test statistic is greater than the critical value (two-sided)
}}
}
\value{
List containing the group-sequential p-values.
}
\description{
\code{calgsp1()} calculates the group-sequential p-values for one hypothesis.
}
\examples{
calgsp1(
  sx = qnorm(1 - c(0.03, 0.04, 0.01)),
  scrit = qnorm(1 - c(0.01, 0.02, 0.025)),
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1
)
}
\author{
Xiaodong Luo
}
\concept{group-sequential p-values}
