% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwsamplesize.R
\name{kwsamplesize}
\alias{kwsamplesize}
\title{Sample Size for the Kruskal-Wallis test.}
\usage{
kwsamplesize(
  shifts,
  distname = c("normal", "logistic", "cauchy"),
  targetpower = 0.8,
  proportions = rep(1, length(shifts))/length(shifts),
  level = 0.05,
  taylor = FALSE
)
}
\arguments{
\item{shifts}{The offsets for the various populations, under the alternative hypothesis.}

\item{distname}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{targetpower}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{proportions}{The proportions in each group.}

\item{level}{The test level.}

\item{taylor}{Logical flag forcing the approximation of exceedence probabilities using the first derivative at zero.}
}
\value{
A list with the total number of observations needed to obtain approximate power, as long as this number is split amomg groups according to argument proportion.
}
\description{
\code{kwsamplesize} approximates sample size for the Kruskal-Wallis test, 
using a chi-square approximation under the null, and a non-central chi-square approximation under the alternative.  The noncentrality parameter is calculated using alternative means and the null variance structure.
}
\details{
The standard noncentral chi-square power formula, is used.
}
\examples{
#Calculate the sample size necessary to detect differences among three
#groups with centers at 0,1,2, from normal observations, using a test of
#level 0.05 and power 0.80.
kwsamplesize(c(0,1,2),"normal")
}
