% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MuChPoint_Class.R
\name{plot,MuChPoint-method}
\alias{plot,MuChPoint-method}
\title{Produce a plot of two-dimensional segmentation of a \code{MuChPoint} fit.}
\usage{
\S4method{plot}{MuChPoint}(x, y, shiny = TRUE, col = "Color", L = NULL, ask = TRUE)
}
\arguments{
\item{x}{an object of class \code{MuChPoint}.}

\item{y}{used  for S4 compatibility represented the matrix (typically,
the matrix used in the program \code{\link{MuChPoint}}).}

\item{shiny}{for a representation with a shiny application.}

\item{col}{for the colors of the representations.}

\item{L}{the summarized matrix with L break-points (L can be a vector).}

\item{ask}{If \code{TRUE}, to hit will be necessary to see next plot.}
}
\description{
Produce a plot of two-dimensional segmentation of a \code{MuChPoint} fit.
}
\examples{
require(MuChPoint)
require(Matrix)
mu=c(rep(c(rep(1,25),rep(0,25)),3))\%*\%t(rep(c(rep(0,25),rep(1,25)),3))
Y=matrix(rnorm(150^2,0,2),150)+mu+t(mu)
Y=as.matrix(forceSymmetric(Y))
res=MuChPoint(Y)
plot(res,Y,L=5,shiny=FALSE)
plot(res,Y,L=1:10,shiny=FALSE,ask=FALSE)

}
\references{
Article: BRAULT V., OUADAH S., SANSONNET L. and LEVY-LEDUC C. Nonparametric
homogeneity tests and multiple change-point estimation for analyzing large Hi-C data matrices.
Journal of Multivariate Analysis, 2017
}
\seealso{
\code{\linkS4class{MuChPoint}}, \code{\link[capushe]{capushe}}.
}
