% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-mts.R
\name{mts_isValid}
\alias{mts_isValid}
\title{Test \emph{mts} object for correct structure}
\usage{
mts_isValid(mts = NULL, verbose = FALSE)
}
\arguments{
\item{mts}{\emph{mts} object}

\item{verbose}{Logical specifying whether to produce detailed warning messages.}
}
\value{
Invisibly returns \code{TRUE} if \code{mts} has the correct structure,
\code{FALSE} otherwise.
}
\description{
The \code{mts} is checked for the presence of core
\code{meta} and \code{data} columns.

Core \code{meta} columns include:

\itemize{
  \item{\code{deviceDeploymentID} -- unique identifier (see \href{https://mazamascience.github.io/MazamaLocationUtils/}{MazmaLocationUtils})}
  \item{\code{deviceID} -- device identifier}
  \item{\code{locationID} -- location identifier (see \href{https://mazamascience.github.io/MazamaLocationUtils/}{MazmaLocationUtils})}
  \item{\code{locationName} -- English language name}
  \item{\code{longitude} -- decimal degrees E}
  \item{\code{latitude} -- decimal degrees N}
  \item{\code{elevation} -- elevation of station in m}
  \item{\code{countryCode} -- ISO 3166-1 alpha-2}
  \item{\code{stateCode} -- ISO 3166-2 alpha-2}
  \item{\code{timezone} -- Olson time zone}
}

Core \code{data} columns include:

\itemize{
  \item{\code{datetime} -- measurement time (UTC)}
}
}
\examples{
library(MazamaTimeSeries)

print(mts_isValid(example_mts))

}
\seealso{
\link{mts_check}
}
