% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCCM_est.R
\name{MCCM_est}
\alias{MCCM_est}
\title{General Function to Estimate Mixed Correlation Coefficient Matrix}
\usage{
MCCM_est(
  dataYX,
  order_indx,
  pair_est = FALSE,
  MLE = FALSE,
  R0 = NULL,
  app = TRUE,
  korder = 2,
  max_iter = 1000,
  max_tol = 1e-08,
  show_log = FALSE
)
}
\arguments{
\item{dataYX}{a dataframe or matrix containing both continuous and ordinal variables.}

\item{order_indx}{a vector to indicate the ordinal variables.}

\item{pair_est}{bool value, TRUE for pairwise estimation, FALSE for simultaneous estimation.}

\item{MLE}{bool value, TRUE for maximum likelihood estimation, FALSE for IRLS (pairwise) or IGMM (simultaneous) estimation.}

\item{R0}{the initial value for correlation vector, default Pearson correlation matrix.}

\item{app}{bool value for approximation, TRUE for Legendre approximation, FALSE for common integral.}

\item{korder}{the order of Legendre approximation.}

\item{max_iter}{max iteration number for IGMM.}

\item{max_tol}{max tolerance for iteration algorithm.}

\item{show_log}{bool value, TRUE for showing calculation log.}
}
\value{
\item{Rmatrix}{Estimated mixed correlation coefficient matrix.}

\item{std_matrix}{Estimated standard deviation for each mixed correlation coefficient.}

\item{COV}{The covariance matrix for MCCM (simultaneous estimation only).}
}
\description{
Estimate the correlation matrix for dataframes containing continuous and ordinal variable, in pairs or simultaneously, using MLE, IRLS, or IGMM.
}
\examples{

library(mvtnorm)
library(MASS)
library(polycor)
library(lavaan)
set.seed(1997)
n = 10000
rho12=0.3
rho13=0.4
rho14=0.5
rho23=0.6
rho24=0.7
rho34=0.8

R = matrix(c(1,rho12,rho13,rho14,rho12,1,rho23,rho24,rho13,rho23,1,rho34,
rho14,rho24,rho34,1),4,4)
indc = c(3,4)
thresholds = list(c(),c(),0,0)
data1 = gen_mixed(n=n,R=R,indc=indc,thresholds=thresholds)
data2 = data.frame(data1$observed)

# pairwise MLE estimation
out_pair_MLE = MCCM_est(dataYX=data2,order_indx=indc,pair_est=TRUE,MLE=TRUE)
# pairwise IRLS estimation
out_pair_IRLS = MCCM_est(dataYX=data2,order_indx=indc,pair_est=TRUE,MLE=FALSE)
# simultaneous MLE estimation
out_sim_MLE = MCCM_est(dataYX=data2,order_indx=indc,pair_est=FALSE,MLE=TRUE)
# simultaneous IGMM estimation
out_sim_IGMM = MCCM_est(dataYX=data2,order_indx=indc,pair_est=FALSE,MLE=FALSE)

summary_MCCM_est(out_pair_MLE)
summary_MCCM_est(out_pair_IRLS)
summary_MCCM_est(out_sim_MLE)
summary_MCCM_est(out_sim_IGMM)
}
\seealso{
\link{esti_polyserial},
\link{esti_polychoric},
\link{est_mixedGMM},
\link{summary_MCCM_est},
\link{draw_correlation_matrix}
}
