% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sims.R
\name{datasim_make}
\alias{datasim_make}
\alias{datasim_to_igraph}
\alias{datasim_intervene}
\title{Construct and modify data simulations}
\usage{
datasim_make(...)

datasim_to_igraph(sim, report_hidden = FALSE)

datasim_intervene(sim, ...)
}
\arguments{
\item{sim}{The data simulation object to be modified.}

\item{report_hidden}{If \code{TRUE}, show the hidden nodes (nodes whose names
begin with a dot.)}

\item{\ldots}{Descriptions of the nodes in the simulation, written in assignment form. See details.}
}
\value{
an object of class "datasim". Internally, this is a list of the R
assignment expressions used when running the simulation.
}
\description{
Construct and modify data simulations
}
\details{
Simulations in \code{LSTbook} are first specified by providing the
code for each node (which can be written in terms of the values of other nodes). Once
constructed, data can be extracted from the simulation using \code{datasim_run(n)} or the
generic \code{take_sample(n)}.

Each argument defines one node in the simulation. The argument syntax is unusual, using
\emph{assignment}. For instance, an argument \code{y <- 3*x + rnorm(n)} defines a node named \code{y}. The R code
on the RHS of the assignment operator (that is, \code{3*x + rnorm(n)} in the example) will
be used by \code{datasim_run()} to generate the \code{y} variable when the simulation is run. Nodes
defined by previous arguments can be used in the code for later arguments.

Helper functions such as \code{mix_with()}, \code{categorical()}, and several others can be used within
the node to perform complex operations.

Remember to use \emph{commas} to separate the arguments in the normal way.
}
\examples{
Simple_sim <- datasim_make(x <- rnorm(n, sd=2), y <- 3*x + rnorm(n))
Simple_sim |> datasim_run(n = 5)
}
