% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCB_applicants.R
\docType{data}
\name{UCB_applicants}
\alias{UCB_applicants}
\title{Roster of applicants to six major departments at UC Berkeley}
\format{
A data.frame object with 4236 rows, one for each of the applicants to
graduate school at UC Berkeley for the Fall 1973 quarter.
\itemize{
\item \code{admit}: Whether the applicant was admitted.
\item \code{gender}: male or female
\item \code{dept}: The graduate department applied to. Rather than identifying the actual
departments involved, the data released by Berkeley used letter codes.
}
}
\source{
The \code{UCBApplicants} summary table in the \code{datasets} R package.
}
\usage{
data(UCB_applicants)
}
\description{
Roster of applicants to six major departments at UC Berkeley
}
\details{
In 1973, officials at the University of California Berkeley noticed
disturbing trends in graduate admissions rates. The data, with department names redacted,
was presented and interpretted in a famous paper in \emph{Science}, Bickel et al. 1975. In
that paper, summary tables were presented. \code{UCB_applicants} was reverse
engineered from \code{datasets::UCBAdmissions} into
a data table where the unit of observation is an individual applicant. The origin of
\code{datasets::UCBAdmissions} is not clear; those data are not explicitly provided in Bickel et al.
}
\references{
Bickel, P. J., Hammel, E. A., and O'Connell, J. W. (1975).
Sex bias in graduate admissions: Data from Berkeley. Science, 187, 398–403.
}
\keyword{datasets}
